//
//  SCMutableBitVector.h
//  SweetCocoaFoundation
//
//  Created by Rico on 1/31/13.
//
//

#import <Foundation/Foundation.h>

enum SCBitState : NSInteger {
    SCBitStateOff    = 0,
    SCBitStateOn     = 1,
    SCBitStateNotSet = 2
};
    
typedef NSInteger SCBitState;

@interface SCMutableBitVector : NSObject <NSCopying>

- (NSUInteger) count;

- (SCBitState)bitAtIndex:(NSUInteger)index;

- (void)setBit:(SCBitState)bit atIndex:(NSUInteger)index;

- (SCBitState)lastBit;

- (SCBitState)firstBit;

- (void) addBit:(SCBitState)bit;

- (NSString*)serializeToStringUsingOff:(NSString*)off on:(NSString*)on notSet:(NSString*)notSet;

- (NSString*)serializeToString;

- (NSInteger) countBits:(SCBitState)bitType;

+ (SCMutableBitVector*)mutableBitVectorFromString:(NSString*)serializedBitVector;

@end
